VERSION 5.00
Object = "{0002E550-0000-0000-C000-000000000046}#1.0#0"; "OWC10.DLL"
Begin VB.Form frmGrafico 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Estadistica COVID-19"
   ClientHeight    =   7290
   ClientLeft      =   -15
   ClientTop       =   270
   ClientWidth     =   13695
   Icon            =   "frmGrafico.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7290
   ScaleWidth      =   13695
   StartUpPosition =   2  'CenterScreen
   Begin VB.ComboBox cmbPaises 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00784414&
      Height          =   345
      ItemData        =   "frmGrafico.frx":058A
      Left            =   5040
      List            =   "frmGrafico.frx":058C
      Style           =   2  'Dropdown List
      TabIndex        =   7
      Top             =   1560
      Width           =   4455
   End
   Begin OWC10.ChartSpace ChartSpace1 
      Height          =   5175
      Left            =   120
      OleObjectBlob   =   "frmGrafico.frx":058E
      TabIndex        =   0
      Top             =   2040
      Width           =   13335
   End
   Begin VB.Label lblFecha3 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "01/01/2020"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H008D681B&
      Height          =   255
      Left            =   11400
      TabIndex        =   10
      Top             =   880
      Width           =   1455
   End
   Begin VB.Label lblFecha2 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "01/01/2020"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H008D681B&
      Height          =   255
      Left            =   6120
      TabIndex        =   9
      Top             =   880
      Width           =   1455
   End
   Begin VB.Label lblFecha1 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "01/01/2020"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H008D681B&
      Height          =   255
      Left            =   360
      TabIndex        =   8
      Top             =   880
      Width           =   1455
   End
   Begin VB.Label lblFallecidos 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "8989"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   11400
      TabIndex        =   6
      Top             =   600
      Width           =   1455
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Fallecidos"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   11400
      TabIndex        =   5
      Top             =   360
      Width           =   1455
   End
   Begin VB.Label lblRecuperados 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "8989"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FF0000&
      Height          =   255
      Left            =   6120
      TabIndex        =   4
      Top             =   600
      Width           =   1455
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Recuperados"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6120
      TabIndex        =   3
      Top             =   360
      Width           =   1455
   End
   Begin VB.Label lblConfirmados 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "8989"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00008000&
      Height          =   255
      Left            =   360
      TabIndex        =   2
      Top             =   600
      Width           =   1455
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Confirmados"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   1
      Top             =   360
      Width           =   1455
   End
   Begin VB.Shape Shape1 
      BackStyle       =   1  'Opaque
      BorderColor     =   &H0000C000&
      Height          =   975
      Left            =   360
      Top             =   240
      Width           =   1455
   End
   Begin VB.Shape Shape2 
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00FF0000&
      Height          =   975
      Left            =   6120
      Top             =   240
      Width           =   1455
   End
   Begin VB.Shape Shape3 
      BackStyle       =   1  'Opaque
      BorderColor     =   &H000000FF&
      Height          =   975
      Left            =   11400
      Top             =   240
      Width           =   1455
   End
End
Attribute VB_Name = "frmGrafico"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim Lista_ISO_Paises() As String

Sub GraficoPais(Infectados, Fallecidos, Recuperados)

    Dim Columnas(3)
    Dim Valores(3)
    
    Columnas(1) = "Infectados"
    Columnas(2) = "Fallecidos"
    Columnas(3) = "Recuperados"
    
    Valores(1) = Infectados
    Valores(2) = Fallecidos
    Valores(3) = Recuperados
    
    numitem = ChartSpace1.Charts(0).SeriesCollection.Count - 1
    If numitem > 0 Then
        
        For i = 0 To numitem
            ChartSpace1.Charts(0).SeriesCollection.Delete (0)
        Next i
    End If
    
    
    Set chConstants = ChartSpace1.Constants
        
    ChartSpace1.Charts(0).SeriesCollection.Add

    ChartSpace1.Charts(0).SeriesCollection(0).Caption = "Infectados"
    ChartSpace1.Charts(0).SeriesCollection(0).SetData chConstants.chDimCategories, chConstants.chDataLiteral, Columnas(1)
    ChartSpace1.Charts(0).SeriesCollection(0).SetData chConstants.chDimValues, chConstants.chDataLiteral, Valores(1)
    
    ChartSpace1.Charts(0).SeriesCollection.Add

    ChartSpace1.Charts(0).SeriesCollection(1).Caption = "Fallecidos"
    ChartSpace1.Charts(0).SeriesCollection(1).SetData chConstants.chDimCategories, chConstants.chDataLiteral, Columnas(2)
    ChartSpace1.Charts(0).SeriesCollection(1).SetData chConstants.chDimValues, chConstants.chDataLiteral, Valores(2)
    
    ChartSpace1.Charts(0).SeriesCollection.Add

    ChartSpace1.Charts(0).SeriesCollection(2).Caption = "Recuperados"
    ChartSpace1.Charts(0).SeriesCollection(2).SetData chConstants.chDimCategories, chConstants.chDataLiteral, Columnas(3)
    ChartSpace1.Charts(0).SeriesCollection(2).SetData chConstants.chDimValues, chConstants.chDataLiteral, Valores(3)
 
    
End Sub

Sub GraficoGlobal()
    Dim Lista_Fechas()
    Dim v_Confirmados()
    Dim v_Fallecidos()
    Dim v_Recuperados()
    Dim NumFechas, Num As Integer
    
    
    Dim p             As Object
    Dim Texto         As String
    Dim sInputJson    As String
    Dim cab           As Integer
    
    Set httpURL = New WinHttp.WinHttpRequest
    
    cadena = "https://covid19.mathdro.id/api/daily/"
    
    httpURL.Open "GET", cadena
    httpURL.Send
    Texto = httpURL.ResponseText
    If Texto = "[]" Then
       MsgBox ("No se obtuvo resultados")
       Exit Sub
    End If
    
    sInputJson = "{items:" & Texto & "}"
    
    Set p = JSON.parse(Texto)
    
    NumFechas = p.Count
    
    ReDim Lista_Fechas(NumFechas)
    ReDim v_Confirmados(NumFechas)
    ReDim v_Fallecidos(NumFechas)
    ReDim v_Recuperados(NumFechas)
    
    For Num = 1 To NumFechas
        Lista_Fechas(Num) = p.Item(Num).Item("reportDate")
        v_Confirmados(Num) = p.Item(Num).Item("confirmed").Item("total")
        v_Fallecidos(Num) = p.Item(Num).Item("deaths").Item("total")
        v_Recuperados(Num) = p.Item(Num).Item("recovered").Item("total")
        
    Next Num
    
    numitem = ChartSpace1.Charts(0).SeriesCollection.Count - 1
    If numitem > 0 Then
        For i = 0 To numitem
            ChartSpace1.Charts(0).SeriesCollection.Delete (0)
        Next i
    End If
    
    Set chConstants = ChartSpace1.Constants
    
    ChartSpace1.Charts(0).SeriesCollection.Add

    ChartSpace1.Charts(0).SeriesCollection(0).Caption = "Infectados"
    ChartSpace1.Charts(0).SeriesCollection(0).SetData chConstants.chDimCategories, chConstants.chDataLiteral, Lista_Fechas
    ChartSpace1.Charts(0).SeriesCollection(0).SetData chConstants.chDimValues, chConstants.chDataLiteral, v_Confirmados
    
    ChartSpace1.Charts(0).SeriesCollection.Add

    ChartSpace1.Charts(0).SeriesCollection(1).Caption = "Fallecidos"
    ChartSpace1.Charts(0).SeriesCollection(1).SetData chConstants.chDimCategories, chConstants.chDataLiteral, Lista_Fechas
    ChartSpace1.Charts(0).SeriesCollection(1).SetData chConstants.chDimValues, chConstants.chDataLiteral, v_Fallecidos
    
    
    
End Sub

Sub DatosGlobales(Optional ISO3 As String = "")
    Dim p             As Object
    Dim Texto         As String
    Dim sInputJson    As String
    Dim cab           As Integer
    
    Set httpURL = New WinHttp.WinHttpRequest
    
    If ISO3 = "" Then
       cadena = "https://covid19.mathdro.id/api"
    Else
       cadena = "https://covid19.mathdro.id/api/countries/" & ISO3
    End If
    
    httpURL.Open "GET", cadena
    httpURL.Send
    Texto = httpURL.ResponseText
    If Texto = "[]" Then
       MsgBox ("No se obtuvo resultados")
       Exit Sub
    End If
    
    sInputJson = "{items:" & Texto & "}"
    
    Set p = JSON.parse(Texto)
    
    ffecha = Mid(p.Item("lastUpdate"), 1, 10)
    ffecha = Replace(ffecha, "-", "/")
    
    Fecha = Format(CDate(ffecha), "dd/mm/yyyy")
    
    lblFecha1.Caption = Fecha
    lblFecha2.Caption = Fecha
    lblFecha3.Caption = Fecha
    
    confirmados = p.Item("confirmed").Item("value")
    lblConfirmados.Caption = FormatNumber(confirmados)
    
    Recuperados = p.Item("recovered").Item("value")
    lblRecuperados.Caption = FormatNumber(Recuperados)
    
    Fallecidos = p.Item("deaths").Item("value")
    lblFallecidos.Caption = FormatNumber(Fallecidos)
    
    If ISO3 = "" Then
        Call GraficoGlobal
    Else
        Call GraficoPais(confirmados, Fallecidos, Recuperados)
    End If
End Sub

Sub ObenerPaises()
    Dim p             As Object
    Dim Texto         As String
    Dim sInputJson    As String
    Dim cab           As Integer
    
     Set httpURL = New WinHttp.WinHttpRequest
     
    'lista de paises
    cadena = "https://covid19.mathdro.id/api/countries"
    httpURL.Open "GET", cadena
    httpURL.Send
    Texto = httpURL.ResponseText
    If Texto = "[]" Then
       MsgBox ("No se obtuvo resultados")
       Exit Sub
    End If
    
    sInputJson = "{items:" & Texto & "}"
    
    Set p = JSON.parse(Texto)
    
    
    NumPaises = p.Item("countries").Count
    ReDim Lista_ISO_Paises(NumPaises)
    cmbPaises.AddItem "Datos Globales"
    index = 1
    For Num = 1 To NumPaises
        nombre_pais = p.Item("countries").Item(Num).Item("name")
        ISO3 = p.Item("countries").Item(Num).Item("iso3")
        cmbPaises.AddItem nombre_pais
        Lista_ISO_Paises(index) = ISO3
        index = index + 1
   Next Num
   
   cmbPaises.ListIndex = 0
End Sub

Private Sub cmbPaises_Click()
    Dim ISO3 As String
    
    index = cmbPaises.ListIndex
    If index > 0 Then
        ISO3 = Lista_ISO_Paises(index)
    Else
        ISO3 = ""
    End If
    
    Call DatosGlobales(ISO3)
    
End Sub


Private Sub Form_Load()
    Call ObenerPaises
    Call GraficoGlobal
End Sub
